#include <bits/stdc++.h>
using namespace std;

struct Item { long long w, v; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    long long W;
    double eps;
    cin >> n >> W >> eps;

    vector<Item> a(n + 1);
    long long vmax = 0;
    for (int i = 1; i <= n; i++) {
        cin >> a[i].w >> a[i].v;
        vmax = max(vmax, a[i].v);
    }

    double Kd = (eps * vmax) / n;
    if (Kd < 1.0) Kd = 1.0;
    long long K = (long long)Kd;

    vector<int> vs(n + 1);
    long long sumv = 0;
    for (int i = 1; i <= n; i++) {
        vs[i] = a[i].v / K;
        sumv += vs[i];
    }

    const long long INF = (1LL << 62);
    vector<vector<long long>> dp(n + 1, vector<long long>(sumv + 1, INF));
    vector<vector<bool>> take(n + 1, vector<bool>(sumv + 1, false));

    dp[0][0] = 0;

    for (int i = 1; i <= n; i++) {
        dp[i][0] = 0;
        for (long long v = 0; v <= sumv; v++) dp[i][v] = dp[i - 1][v];
        for (long long v = vs[i]; v <= sumv; v++) {
            long long prev = dp[i - 1][v - vs[i]];
            if (prev + a[i].w < dp[i][v]) {
                dp[i][v] = prev + a[i].w;
                take[i][v] = true;
            }
        }
    }

    long long bestv = 0;
    for (long long v = 0; v <= sumv; v++)
        if (dp[n][v] <= W) bestv = v;

    vector<int> chosen;
    long long v = bestv;
    for (int i = n; i >= 1; i--) {
        if (v >= vs[i] && take[i][v]) {
            chosen.push_back(i);
            v -= vs[i];
        }
    }
    reverse(chosen.begin(), chosen.end());

    cout << chosen.size() << "\n";
    for (int x : chosen) cout << x << " ";
    cout << "\n";
}